<?php
/**
 * Plugin Name: Plugin Jadwal Sholat
 * Description: Menampilkan jadwal sholat dengan pengaturan kustomisasi.
 * Version: 1.0
 * Author: bungrahman
 */

if (!defined('ABSPATH')) exit;

// Enqueue Bootstrap, Font Awesome & Media Uploader
function enqueue_bootstrap() {
    if (!isset($_GET['page']) || $_GET['page'] !== 'jadwal-sholat') {
        return;
    }
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css');
    wp_enqueue_media();
    wp_enqueue_script('custom-upload', plugins_url('upload.js', __FILE__), array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'enqueue_bootstrap');


// Register settings
function jadwal_sholat_register_settings() {
    $options = [
        'js_default_city', 'js_image', 'js_bg_form', 'js_bg_input', 'js_color_font',
        'js_bg_jadwal', 'js_color_nama', 'js_color_jam', 'js_font_size_jadwal',
        'js_font_size_jam', 'js_bg_tampilan'
    ];
    foreach ($options as $option) {
        register_setting('jadwal_sholat_options', $option);
    }
}
add_action('admin_init', 'jadwal_sholat_register_settings');

// Create admin menu
function jadwal_sholat_menu() {
    add_menu_page('Jadwal Sholat', 'Jadwal Sholat', 'manage_options', 'jadwal-sholat', 'jadwal_sholat_settings_page', 'dashicons-clock', 20);
}
add_action('admin_menu', 'jadwal_sholat_menu');

// Admin settings page
function jadwal_sholat_settings_page() {
    // Ambil daftar kota dari API (gunakan cache)
    $cache_key = 'jadwal_sholat_all_cities';
    $all_cities = get_transient($cache_key);

    if (!$all_cities) {
        $cities_url = "https://api.myquran.com/v2/sholat/kota/semua";
        $cities_response = wp_remote_get($cities_url);

        if (!is_wp_error($cities_response)) {
            $cities_data = json_decode(wp_remote_retrieve_body($cities_response), true);
            if (!empty($cities_data['data'])) {
                $all_cities = $cities_data['data'];
                set_transient($cache_key, $all_cities, 12 * HOUR_IN_SECONDS);
            }
        }
    }
    // Ambil kota default yang tersimpan
    $default_city = get_option('js_default_city', 'Batam');
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-3" style="background-color: #ffffff; padding: 20px; border-radius: 5px;">
                <h4 class="mb-3">Pengaturan Jadwal Sholat</h4>
                <form method="post" action="options.php" enctype="multipart/form-data" class="needs-validation">
                    <?php settings_fields('jadwal_sholat_options'); ?>
                    <div class="mb-3">
                        <label class="form-label">Default Kota</label>
                        <select name="js_default_city" class="form-control">
                            <?php foreach ($all_cities as $kota): ?>
                                <option value="<?php echo esc_attr($kota['lokasi']); ?>" <?php selected($kota['lokasi'], $default_city); ?>>
                                    <?php echo esc_html($kota['lokasi']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Upload Gambar</label>
                        <div class="input-group">
                            <input type="text" id="js_image" name="js_image" class="form-control" value="<?php echo get_option('js_image'); ?>">
                            <button type="button" class="btn btn-secondary" id="upload_image_button">Upload</button>
                        </div>
                        <?php if (get_option('js_image')): ?>
                            <img src="<?php echo get_option('js_image'); ?>" class="img-thumbnail mt-2" width="150">
                        <?php endif; ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Latar Tampilan</label>
                        <input type="color" name="js_bg_tampilan" class="form-control form-control-color" value="<?php echo get_option('js_bg_tampilan', '#f8f9fa'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Latar Form</label>
                        <input type="color" name="js_bg_form" class="form-control form-control-color" value="<?php echo get_option('js_bg_form', '#f8f9fa'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Latar Input Pencarian</label>
                        <input type="color" name="js_bg_input" class="form-control form-control-color" value="<?php echo get_option('js_bg_input', '#ffffff'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Font Pencarian</label>
                        <input type="color" name="js_color_font" class="form-control form-control-color" value="<?php echo get_option('js_color_font', '#000000'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Latar Semua Jadwal & Do'a</label>
                        <input type="color" name="js_bg_jadwal" class="form-control form-control-color" value="<?php echo get_option('js_bg_jadwal', '#ffffff'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Nama Jadwal</label>
                        <input type="color" name="js_color_nama" class="form-control form-control-color" value="<?php echo get_option('js_color_nama', '#000000'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna Jam</label>
                        <input type="color" name="js_color_jam" class="form-control form-control-color" value="<?php echo get_option('js_color_jam', '#000000'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ukuran Font Jadwal</label>
                        <input type="number" name="js_font_size_jadwal" class="form-control" value="<?php echo get_option('js_font_size_jadwal', '16'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ukuran Font Jam</label>
                        <input type="number" name="js_font_size_jam" class="form-control" value="<?php echo get_option('js_font_size_jam', '20'); ?>">
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan Pengaturan</button>
                </form>
            </div>
            <div class="col-md-9" style="background-color: #f8f9fa; padding: 20px; border-radius: 5px;">
                <h4 class="mb-3">Pratinjau Jadwal Sholat</h4>
                <div class="preview-box" style="background-color: <?php echo esc_attr(get_option('js_bg_tampilan', '#f8f9fa')); ?>; padding: 15px; border-radius: 5px;">
                    <div style="background-color: <?php echo esc_attr(get_option('js_bg_form', '#f8f9fa')); ?>; color: <?php echo esc_attr(get_option('js_color_font', '#000000')); ?>;">
                        <?php echo do_shortcode('[jadwal_sholat kota="' . esc_attr($default_city) . '"]'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
    jQuery(document).ready(function($) {
        $('#upload_image_button').click(function(e) {
            e.preventDefault();
            var image = wp.media({
                title: 'Upload Gambar',
                multiple: false
            }).open()
            .on('select', function(){
                var uploaded_image = image.state().get('selection').first();
                var image_url = uploaded_image.toJSON().url;
                $('#js_image').val(image_url);
            });
        });
    });
    </script>
    <?php
}


// Shortcode Jadwal Sholat
function jadwal_sholat_shortcode($atts) {
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css');
    $default_city_name = get_option('js_default_city', 'Batam'); // Kota default dari pengaturan
    $default_date = date('Y-m-d');

    // Ambil kota & tanggal dari URL, jika kosong gunakan default
    $city = isset($_GET['city']) ? sanitize_text_field($_GET['city']) : $default_city_name;
    $date = isset($_GET['date']) ? sanitize_text_field($_GET['date']) : $default_date;

    // Ambil daftar semua kota (cache 12 jam)
    $cache_key = 'jadwal_sholat_all_cities';
    $all_cities = get_transient($cache_key);

    if (!$all_cities) {
        $cities_url = "https://api.myquran.com/v2/sholat/kota/semua";
        $cities_response = wp_remote_get($cities_url);

        if (!is_wp_error($cities_response)) {
            $cities_data = json_decode(wp_remote_retrieve_body($cities_response), true);
            if (!empty($cities_data['data'])) {
                $all_cities = $cities_data['data'];
                set_transient($cache_key, $all_cities, 12 * HOUR_IN_SECONDS);
            }
        }
    }

    // Temukan ID kota berdasarkan nama kota yang dipilih
    $city_id = null;
    if (!empty($all_cities)) {
        foreach ($all_cities as $kota) {
            if (strcasecmp($kota['lokasi'], $city) === 0) {
                $city_id = $kota['id'];
                $city = $kota['lokasi']; // Pastikan dropdown tetap sesuai
                break;
            }
        }
    }

    // Ambil Jadwal Sholat dari API
    $jadwal = [];
    if ($city_id) {
        $schedule_url = "https://api.myquran.com/v2/sholat/jadwal/{$city_id}/{$date}";
        $schedule_response = wp_remote_get($schedule_url);

        if (!is_wp_error($schedule_response)) {
            $schedule_data = json_decode(wp_remote_retrieve_body($schedule_response), true);
            if (!empty($schedule_data['data']['jadwal'])) {
                $jadwal = $schedule_data['data']['jadwal'];
            }
        }
    }
    

    // Ambil Doa Harian
    $doa_url = "https://api.myquran.com/v2/doa/acak";
    $doa_response = wp_remote_get($doa_url);
    $doa_data = json_decode(wp_remote_retrieve_body($doa_response), true);
    $doa = $doa_data['data'] ?? null;

    ob_start();
    ?>
    <style>
        .select2-container .select2-selection--single {
            height: auto !important;
        }
        .select2-container {
            width: 100% !important;
            }
    </style>
    <div class="container my-4 p-3" style="background: <?php echo get_option('js_bg_tampilan', '#f8f9fa'); ?>;">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="text-center mt-2">
                    <h3 class="fw-bold" style="font-size: 20px; color: <?php echo get_option('js_color_jam', '#000000'); ?>;">
                        <i class="fas fa-calendar-alt"></i> <span id="current-date">Loading...</span>
                    </h3>
                </div>
                <!-- Jam Digital -->
               <div class="text-center mt-2">
                    <h2 class="fw-bold" style="font-size: 48px; color: <?php echo get_option('js_color_jam', '#000000'); ?>; font-family: 'Courier New', Courier, monospace;">
                        <span id="digital-clock">Loading...</span>
                    </h2>
                </div>
                
                <script>
                // JavaScript untuk Jam Digital dan Tanggal Hari Ini
                document.addEventListener("DOMContentLoaded", function () {
                    // Fungsi untuk memperbarui tanggal hari ini
                    function updateDate() {
                        let today = new Date();
                        let day = today.getDate().toString().padStart(2, "0");
                        let month = (today.getMonth() + 1).toString().padStart(2, "0");
                        let year = today.getFullYear();
                        let formattedDate = `${day}/${month}/${year}`;
                        document.getElementById("current-date").textContent = `${formattedDate}`;
                    }
                
                    // Fungsi untuk jam digital
                    function updateClock() {
                        let now = new Date();
                        let hours = now.getHours().toString().padStart(2, "0");
                        let minutes = now.getMinutes().toString().padStart(2, "0");
                        let seconds = now.getSeconds().toString().padStart(2, "0");
                        document.getElementById("digital-clock").textContent = `${hours}:${minutes}:${seconds}`;
                    }
                
                    updateDate(); // Tampilkan tanggal hari ini
                    setInterval(updateClock, 1000); // Update jam setiap detik
                });
                </script>
                <form method="GET" action="" class="p-3 rounded shadow-sm" style="background: <?php echo get_option('js_bg_form', '#f8f9fa'); ?>;">
                    <div class="mb-3">
                        <label class="form-label" style="color: <?php echo get_option('js_color_font', '#000000'); ?>;">Nama Kota</label>
                        <select name="city" id="city-select" class="form-control">
                            <?php if (!empty($all_cities)): ?>
                                <?php foreach ($all_cities as $kota): ?>
                                    <option value="<?php echo esc_attr($kota['lokasi']); ?>" <?php selected($kota['lokasi'], $city); ?>>
                                        <?php echo esc_html($kota['lokasi']); ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <option value="">Kota tidak tersedia</option>
                            <?php endif; ?>
                        </select>

                    </div>
                    <div class="mb-3">
                        <label class="form-label" style="color: <?php echo get_option('js_color_font', '#000000'); ?>;">Tanggal</label>
                        <input type="date" name="date" class="form-control w-100" value="<?php echo esc_attr($date); ?>" onchange="this.form.submit()">
                    </div>

                    <noscript><button type="submit" class="btn btn-primary w-100">Cari</button></noscript>
                    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
                    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
                    
                    <script>
                    jQuery(document).ready(function($) {
                        $('#city-select').select2({
                            placeholder: "Pilih Kota...",
                            allowClear: true
                        });
                    
                        // Trigger form submit saat memilih kota
                        $('#city-select').on('change', function() {
                            $(this).closest("form").submit();
                        });
                    });
                    </script>

                </form>
            </div>
            <style>
                @media (max-width: 767px) {
                    .col-md-6 img {
                        max-height: 180px; /* Sesuaikan tinggi maksimum gambar di seluler */
                    }
                }
            </style>
            <div class="col-md-6 text-center">
                <img src="<?php echo get_option('js_image', 'https://upload.wikimedia.org/wikipedia/commons/4/4b/Welcome_to_Batam.jpg'); ?>" alt="Gambar Kota" class="img-fluid w-100 rounded shadow" style="width: 320px; height: 240px; object-fit: cover;">
            </div>
        </div>

        <?php if (!empty($jadwal)): ?>
        
        <div class="text-center mt-4">
            <h4 class="fw-bold" style="color: <?php echo get_option('js_color_jam', '#000000'); ?>;">Jadwal Sholat <?php echo esc_html($city); ?></h4>
        </div>
        <div class="row mt-4">
            <?php foreach (['imsak', 'subuh', 'terbit', 'dhuha', 'dzuhur', 'ashar', 'maghrib', 'isya'] as $waktu) : ?>
                <div class="col-md-3 col-6 mb-3">
                    <div class="p-3 text-center rounded shadow-sm" style="background: <?php echo get_option('js_bg_jadwal', '#ffffff'); ?>;">
                        <h5 class="fw-bold" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>; font-size: <?php echo get_option('js_font_size_jadwal', '16'); ?>px;">
                            <?php echo ucfirst($waktu); ?>
                        </h5>
                        <p class="fw-bold jadwal-waktu" data-waktu="<?php echo esc_attr($jadwal[$waktu] ?? '-'); ?>" 
                           style="color: <?php echo get_option('js_color_jam', '#000000'); ?>; 
                           font-size: <?php echo get_option('js_font_size_jam', '20'); ?>px; font-family: 'Courier New', Courier, monospace;">
                           <?php echo esc_html($jadwal[$waktu] ?? '-'); ?>
                        </p>
                        <p class="countdown-timer" style="color: red; font-size: 14px;">Loading...</p>
            
            
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <?php endif; ?>

        <?php if ($doa): ?>
        <div class="mt-4 p-3 text-center rounded shadow-sm" style="background: <?php echo get_option('js_bg_jadwal', '#ffffff'); ?>;">
            <h5 class="fw-bold" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>;">Doa Harian: <?php echo esc_html($doa['judul'] ?? 'Doa'); ?></h5>
            <p class="fs-4" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>;"><?php echo esc_html($doa['doa'] ?? $doa['ayat'] ?? ''); ?></p>
            <p class="fs-4" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>;"><?php echo esc_html($doa['artinya'] ?? $doa['indo'] ?? ''); ?></p>
        </div>
        <?php endif; ?>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
        function updateCountdown() {
            let now = new Date();
            let selectedDate = new Date("<?php echo esc_js($date); ?>"); // Ambil tanggal yang dipilih dari PHP
            let jadwalElements = document.querySelectorAll(".jadwal-waktu");
            let nextPrayerTime = null;
    
            // Periksa apakah tanggal yang dipilih bukan hari ini
            if (selectedDate.toDateString() !== now.toDateString()) {
                // Sembunyikan countdown jika tanggal bukan hari ini
                document.querySelectorAll(".countdown-timer").forEach(function (element) {
                    element.style.display = "none";
                });
                return; // Keluar dari fungsi jika bukan hari ini
            } else {
                // Tampilkan countdown jika tanggal hari ini
                document.querySelectorAll(".countdown-timer").forEach(function (element) {
                    element.style.display = "block";
                });
            }
    
            jadwalElements.forEach(function (element) {
                let jadwalWaktu = element.getAttribute("data-waktu"); // Format: HH:MM
                if (!jadwalWaktu) return;
    
                let [hours, minutes] = jadwalWaktu.split(":").map(Number);
                let targetTime = new Date();
                targetTime.setHours(hours, minutes, 0, 0);
    
                let countdownElement = element.nextElementSibling; // Elemen countdown
                let diff = targetTime - now;
    
                if (diff > 0) {
                    let hoursLeft = Math.floor(diff / (1000 * 60 * 60));
                    let minutesLeft = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                    let secondsLeft = Math.floor((diff % (1000 * 60)) / 1000);
                    countdownElement.textContent = `Sisa waktu: ${hoursLeft}j ${minutesLeft}m ${secondsLeft}d`;
                } else {
                    countdownElement.textContent = "Selesai";
                }
            });
    
            
        }
    
        updateCountdown(); // Jalankan pertama kali
        setInterval(updateCountdown, 1000); // Perbarui setiap detik
    });

    </script>



    <?php
    return ob_get_clean();
}
add_shortcode('jadwal_sholat', 'jadwal_sholat_shortcode');

// Shortcode Jadwal Sholat
function jadwal_sholat_only_shortcode($atts) {
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css');
    $default_city_name = get_option('js_default_city', 'Batam'); // Kota default dari pengaturan
    $default_date = date('Y-m-d');

    // Ambil kota & tanggal dari URL, jika kosong gunakan default
    $city = isset($_GET['city']) ? sanitize_text_field($_GET['city']) : $default_city_name;
    $date = isset($_GET['date']) ? sanitize_text_field($_GET['date']) : $default_date;

    // Ambil daftar semua kota (cache 12 jam)
    $cache_key = 'jadwal_sholat_all_cities';
    $all_cities = get_transient($cache_key);

    if (!$all_cities) {
        $cities_url = "https://api.myquran.com/v2/sholat/kota/semua";
        $cities_response = wp_remote_get($cities_url);

        if (!is_wp_error($cities_response)) {
            $cities_data = json_decode(wp_remote_retrieve_body($cities_response), true);
            if (!empty($cities_data['data'])) {
                $all_cities = $cities_data['data'];
                set_transient($cache_key, $all_cities, 12 * HOUR_IN_SECONDS);
            }
        }
    }

    // Temukan ID kota berdasarkan nama kota yang dipilih
    $city_id = null;
    if (!empty($all_cities)) {
        foreach ($all_cities as $kota) {
            if (strcasecmp($kota['lokasi'], $city) === 0) {
                $city_id = $kota['id'];
                $city = $kota['lokasi']; // Pastikan dropdown tetap sesuai
                break;
            }
        }
    }

    // Ambil Jadwal Sholat dari API
    $jadwal = [];
    if ($city_id) {
        $schedule_url = "https://api.myquran.com/v2/sholat/jadwal/{$city_id}/{$date}";
        $schedule_response = wp_remote_get($schedule_url);

        if (!is_wp_error($schedule_response)) {
            $schedule_data = json_decode(wp_remote_retrieve_body($schedule_response), true);
            if (!empty($schedule_data['data']['jadwal'])) {
                $jadwal = $schedule_data['data']['jadwal'];
            }
        }
    }

    ob_start();
    if (!empty($jadwal)):
        ?>
        <div class="text-center mt-4">
            <h4 class="fw-bold" style="color: <?php echo get_option('js_color_jam', '#000000'); ?>;">Jadwal Sholat <?php echo esc_html($city); ?></h4>
        </div>
        <div class="row mt-4">
            <?php foreach (['imsak', 'subuh', 'terbit', 'dhuha', 'dzuhur', 'ashar', 'maghrib', 'isya'] as $waktu) : ?>
                <div class="col-md-3 col-6 mb-3">
                    <div class="p-3 text-center rounded shadow-sm" style="background: <?php echo get_option('js_bg_jadwal', '#ffffff'); ?>;">
                        <h5 class="fw-bold" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>; font-size: <?php echo get_option('js_font_size_jadwal', '16'); ?>px;">
                            <?php echo ucfirst($waktu); ?>
                        </h5>
                        <p class="fw-bold jadwal-waktu" data-waktu="<?php echo esc_attr($jadwal[$waktu] ?? '-'); ?>" 
                           style="color: <?php echo get_option('js_color_jam', '#000000'); ?>; 
                           font-size: <?php echo get_option('js_font_size_jam', '20'); ?>px; font-family: 'Courier New', Courier, monospace;">
                           <?php echo esc_html($jadwal[$waktu] ?? '-'); ?>
                        </p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    <?php
    return ob_get_clean();
}
add_shortcode('jadwal_sholat_only', 'jadwal_sholat_only_shortcode');

// Shortcode Doa Harian
function doa_harian_shortcode($atts) {
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css');
    // Ambil Doa Harian
    $doa_url = "https://api.myquran.com/v2/doa/acak";
    $doa_response = wp_remote_get($doa_url);
    $doa_data = json_decode(wp_remote_retrieve_body($doa_response), true);
    $doa = $doa_data['data'] ?? null;

    ob_start();
    if ($doa):
        ?>
        <div class="mt-4 p-3 text-center rounded shadow-sm" style="background: <?php echo get_option('js_bg_jadwal', '#ffffff'); ?>;">
            <h5 class="fw-bold" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>;">Doa Harian: <?php echo esc_html($doa['judul'] ?? 'Doa'); ?></h5>
            <p class="fs-4" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>;"><?php echo esc_html($doa['doa'] ?? $doa['ayat'] ?? ''); ?></p>
            <p class="fs-4" style="color: <?php echo get_option('js_color_nama', '#000000'); ?>;"><?php echo esc_html($doa['artinya'] ?? $doa['indo'] ?? ''); ?></p>
        </div>
        <?php
    endif;
    return ob_get_clean();
}
add_shortcode('doa_harian', 'doa_harian_shortcode');








